/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.block.BaseBlock;
import dev.toma.gunsrpg.common.tileentity.TrapTileEntity;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TrapBlock
extends BaseBlock {
    public static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    public static final VoxelShape COLLISION = VoxelShapes.func_197873_a((double)0.1, (double)0.0, (double)0.1, (double)0.9, (double)0.1, (double)0.9);
    private final ITrapReaction reaction;

    public TrapBlock(String name, AbstractBlock.Properties properties, ITrapReaction reaction) {
        super(name, properties);
        this.reaction = reaction;
    }

    public void func_196262_a(BlockState state, World level, BlockPos pos, Entity entity) {
        this.applyTrapEffects(level, pos, entity);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return COLLISION;
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return true;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (this.reaction.requiresSpecialTool()) {
            this.applyTrapEffects(world, pos, (Entity)player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (level.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (this.reaction.requiresSpecialTool()) {
            if (this.reaction.isValidDefuseTool(level, pos, player, hand)) {
                level.func_175655_b(pos, false);
                player.func_184586_b(hand).func_96631_a(1, level.func_201674_k(), (ServerPlayerEntity)player);
            } else {
                this.applyTrapEffects(level, pos, (Entity)player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!this.func_196260_a(p_220069_1_, (IWorldReader)p_220069_2_, p_220069_3_)) {
            p_220069_2_.func_175655_b(p_220069_3_, true);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader reader, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        BlockState stateBelow = reader.func_180495_p(below);
        VoxelShape shape = stateBelow.func_196952_d((IBlockReader)reader, below);
        return stateBelow.func_185904_a().func_76220_a() && shape.func_197758_c(Direction.Axis.Y) == 1.0;
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult result, ProjectileEntity entity) {
        this.reaction.onHitByProjectile(world, result.func_216350_a(), entity);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TrapTileEntity();
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tileEntity = level.func_175625_s(pos);
        if (entity != null && tileEntity instanceof TrapTileEntity) {
            UUID owner = entity.func_110124_au();
            ((TrapTileEntity)tileEntity).setOwner(owner);
        }
    }

    protected void onEntityCaught(World world, BlockPos pos, Entity victim) {
    }

    private void applyTrapEffects(World world, BlockPos pos, Entity victim) {
        boolean countAsPlayerKill;
        TileEntity entity = world.func_175625_s(pos);
        TrapTileEntity trapTileEntity = null;
        if (entity instanceof TrapTileEntity) {
            trapTileEntity = (TrapTileEntity)entity;
        }
        if (this.reaction.applyTrapEffects(world, pos, victim, trapTileEntity, countAsPlayerKill = GunsRPG.config.skills.countTrapKills)) {
            this.onEntityCaught(world, pos, victim);
        }
    }

    public static class MineReaction
    implements ITrapReaction {
        private final float explosionPower;
        private final Explosion.Mode explosionMode;

        public MineReaction(float explosionPower) {
            this(explosionPower, Explosion.Mode.NONE);
        }

        public MineReaction(float explosionPower, Explosion.Mode explosionMode) {
            this.explosionPower = Math.max(1.0f, explosionPower);
            this.explosionMode = Objects.requireNonNull(explosionMode);
        }

        @Override
        public boolean applyTrapEffects(World level, BlockPos pos, Entity entity, @Nullable TrapTileEntity tileEntity, boolean countAsPlayerKill) {
            if (!level.field_72995_K) {
                PlayerEntity owner = null;
                if (countAsPlayerKill && tileEntity != null) {
                    owner = tileEntity.getOwnerAsEntity();
                }
                level.func_175655_b(pos, false);
                level.func_217385_a((Entity)owner, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, this.explosionPower, this.explosionMode);
            }
            return true;
        }

        @Override
        public boolean requiresSpecialTool() {
            return true;
        }

        @Override
        public boolean isValidDefuseTool(World level, BlockPos pos, PlayerEntity player, Hand hand) {
            return false;
        }

        @Override
        public void onHitByProjectile(World level, BlockPos pos, ProjectileEntity projectile) {
            TileEntity entity = level.func_175625_s(pos);
            TrapTileEntity trapTileEntity = null;
            if (entity instanceof TrapTileEntity) {
                trapTileEntity = (TrapTileEntity)entity;
            }
            boolean countAsPlayerKill = GunsRPG.config.skills.countTrapKills;
            this.applyTrapEffects(level, pos, (Entity)projectile, trapTileEntity, countAsPlayerKill);
        }
    }

    public static interface ITrapReaction {
        public boolean applyTrapEffects(World var1, BlockPos var2, Entity var3, @Nullable TrapTileEntity var4, boolean var5);

        public boolean requiresSpecialTool();

        public boolean isValidDefuseTool(World var1, BlockPos var2, PlayerEntity var3, Hand var4);

        default public void onHitByProjectile(World level, BlockPos pos, ProjectileEntity projectile) {
        }
    }
}

